package
{
	import com.pokkt.plugin.AdConfig;
	import com.pokkt.plugin.PokktConfig;
	import com.pokkt.plugin.PokktManager;
	import com.pokkt.plugin.utilities.PokktEvent;
	
	import flash.display.StageAspectRatio;
	
	import starling.display.Button;
	import starling.events.Event;
	import starling.text.TextField;
	
	public class PlayVideoScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnStartCaching:Button;
		private var _btnShowAd:Button;
		private var _btnExportLogs:Button;
		private var _txtEarnedPoint:TextField;
		private var _txtInfo:TextField;
		private var _txtScreenName:TextField;
		private var _yPadding:int = 15;
		private var _totalEarnedPoint:Number = 0.0;
		private var _callback:Function;
		
		private var _pokktConfig:PokktConfig;
		private var _screenName:String = "";
		private var _isRewarded:Boolean = false;
		private var _adConfig:AdConfig;
		
		public function PlayVideoScreen(callback:Function, screenName:String, isRewarded:Boolean)
		{
			super();
			
			_callback = callback;
			_screenName = screenName;
			_isRewarded = isRewarded;
			
			_imgLogo.y = _imgLogo.y/2;
			
			_txtScreenName = GetUIComponent.getTextField("Points earned: 0", 14 / Constants.ContentScaleFactor, false);
			_txtScreenName.x = 10 * Constants.X_SCALE;
			_txtScreenName.y = _imgLogo.y  +_imgLogo.height;
			_txtScreenName.text = "Screen Name: " + screenName;
			addChild(_txtScreenName); 
			
			_txtEarnedPoint = GetUIComponent.getTextField("Points earned: 0", 14 / Constants.ContentScaleFactor, false);
			_txtEarnedPoint.x = 10 * Constants.X_SCALE;
			_txtEarnedPoint.y = _txtScreenName.y  +_txtScreenName.height;
			addChild(_txtEarnedPoint);
			
			_txtInfo = GetUIComponent.getTextField("", 13 / Constants.ContentScaleFactor, false);
			_txtInfo.x = 10 * Constants.X_SCALE;
			_txtInfo.y = _txtEarnedPoint.y  +_txtEarnedPoint.height + _yPadding/2 * Constants.Y_SCALE;
			addChild(_txtInfo);
			
			_btnStartCaching = GetUIComponent.getButton(BUTTON1, "Start Caching", 10);
			_btnStartCaching.y = _txtInfo.y + _txtInfo.height + _yPadding * Constants.Y_SCALE;
			_btnStartCaching.addEventListener(Event.TRIGGERED, onStartCachingClick);
			addChild(_btnStartCaching);
			
			var btnTxt:String = "";
			
			if(_isRewarded) btnTxt = "Show Rewarded (without caching)"; 
			else btnTxt = "Show Non-Rewarded (without caching)";
			
			_btnShowAd = GetUIComponent.getButton(BUTTON1, btnTxt, 10);
			_btnShowAd.y = _btnStartCaching.y + _btnStartCaching.height + _yPadding * Constants.Y_SCALE;
			_btnShowAd.addEventListener(Event.TRIGGERED, onShowAdClicked);
			addChild(_btnShowAd);
			
			_btnExportLogs = GetUIComponent.getButton(BUTTON2, "Export Logs", 10);
			_btnExportLogs.y = _btnShowAd.y + _btnShowAd.height + _yPadding * Constants.Y_SCALE;
			addChild(_btnExportLogs);
			_btnExportLogs.addEventListener(Event.TRIGGERED, onExportLogsClicked);
			
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_AVAILABILITY_STATUS_EVENT, onAdAvailability);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_CACHING_COMPLETED_EVENTS, onAdCachingCompleted);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_CACHING_FAILED_EVENTS, onAdCachingFailed);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_CLOSED_EVENTS, onAdClosed);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_COMPLETED_EVENTS, onAdCompleted);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_SKIPPED_EVENTS, onAdSkipped);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_DISPLAYED_EVENTS, onAdDisplayed);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_GRATIFIED_EVENTS, onAdGratified);
		}
		
		private function showButton(rewardValue:Number, isAdAvailable:Boolean, adConfig:AdConfig):void
		{
			if(isAdAvailable) 
			{
				_btnShowAd.enabled = true;
				
				if(_isRewarded)
				{
					_btnShowAd.text = "Show Incent Ad To Earn " + rewardValue + " (Caching)";
				} 
				else
				{
					_btnShowAd.text = "Show Non-Incent Ad To Earn " + rewardValue + " (Caching)";
				}
			}
		}
		
		private function resetButton():void
		{
			_btnShowAd.enabled = true;
			_btnStartCaching.enabled = true;
			
			var btnTxt:String;
			if(_isRewarded) btnTxt = "Show Non-Rewarded (without caching)"; 
			else btnTxt = "Show Rewarded (without caching)";
			_btnShowAd.text = btnTxt;
		}
		
		private function showAd(isAdAvailable:Boolean, adConfig:AdConfig):void
		{
			if(isAdAvailable)
			{
				PokktManager.showAd(adConfig);
			}
		}
		
		//Button click functions
		
		protected function onStartCachingClick(event:Event):void
		{
			_btnShowAd.enabled = false;
			_btnStartCaching.enabled = false;
			
			_adConfig = new AdConfig();
			_adConfig.screenName = _screenName;
			_adConfig.isRewarded = _isRewarded;
			_adConfig.defaultSkipTime = 5;
			_adConfig.backButtonDisabled = false;
			PokktManager.cacheAd(_adConfig); 
		}
		
		protected function onShowAdClicked(event:starling.events.Event):void
		{
			_btnShowAd.enabled = false;
			_btnStartCaching.enabled = false;
			
			if(!_adConfig)
			{
				_adConfig = new AdConfig();
				_adConfig.screenName = _screenName;
				_adConfig.isRewarded = _isRewarded;
				_adConfig.defaultSkipTime = 5;
				_adConfig.backButtonDisabled = false;
			}
			PokktManager.checkAdAvailability(_adConfig);
		}
		
		private function onExportLogsClicked():void
		{
			PokktManager.exportLog();
		}
		
		protected function onAdCachingCompleted(event:PokktEvent):void
		{
			trace("onAdCachingCompleted: " + event.adConfig);
			showButton(event.rewardValue, event.isAdAvailable, event.adConfig);
		}
		
		protected function onAdCachingFailed(event:PokktEvent):void
		{
			trace("onAdCachingFailed: " + event.adConfig);
			showButton(event.rewardValue, event.isAdAvailable, event.adConfig);
			resetButton();
		}
		
		protected function onAdAvailability(event:PokktEvent):void
		{
			trace("onAdAvailability called: " + event.isAdAvailable);
			if(event.isAdAvailable)
			{
				showButton(event.rewardValue, event.isAdAvailable, event.adConfig);
				showAd(event.isAdAvailable, event.adConfig);
			}
			else
			{
				resetButton();
			}
		}
		
		protected function onAdGratified(event:PokktEvent):void
		{
			trace("onAdGratified: rewardValue: " + event.rewardValue);
			_totalEarnedPoint = _totalEarnedPoint + event.rewardValue;
			_txtEarnedPoint.text = "Points earned: "  + _totalEarnedPoint;
		}
		
		protected function onAdDisplayed(event:PokktEvent):void
		{
			//Constants.STAGE.setAspectRatio(StageAspectRatio.LANDSCAPE);
			trace("onAdDisplayed: ", event.adConfig);
		}
		
		protected function onAdSkipped(event:PokktEvent):void
		{
			trace("onAdSkipped");
		}
		
		protected function onAdCompleted(event:PokktEvent):void
		{
			trace("onAdCompleted");
		}
		
		protected function onAdClosed(event:PokktEvent):void
		{
			Constants.STAGE.setAspectRatio( StageAspectRatio.PORTRAIT );
			resetButton();
		}
		
		//Dispose method
		override public function dispose():void
		{
			super.dispose();
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_AVAILABILITY_STATUS_EVENT, onAdAvailability);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_CACHING_COMPLETED_EVENTS, onAdCachingCompleted);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_CACHING_FAILED_EVENTS, onAdCachingFailed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_CLOSED_EVENTS, onAdClosed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_COMPLETED_EVENTS, onAdCompleted);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_SKIPPED_EVENTS, onAdSkipped);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_DISPLAYED_EVENTS, onAdDisplayed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_GRATIFIED_EVENTS, onAdGratified);
		}
	}
}