package
{	
	import com.pokkt.plugin.InAppPurchaseDetail;
	import com.pokkt.plugin.PokktConfig;
	import com.pokkt.plugin.PokktManager;
	import com.pokkt.plugin.utilities.AnalyticsType;
	import com.pokkt.plugin.utilities.IAPStoreType;
	import com.pokkt.plugin.utilities.PokktEvent;
	import com.pokkt.plugin.utilities.PokktIntegrationType;
	
	import flash.desktop.NativeApplication;
	import flash.events.KeyboardEvent;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.ui.Keyboard;
	
	import starling.core.Starling;
	import starling.display.Button;
	import starling.display.Sprite;
	import starling.events.Event;
	import starling.text.TextField;
	import starling.utils.Color;
	import starling.utils.HAlign;

	public class MainScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnInitPokkt:Button;
		private var _btnTestOfferwall:Button;
		private var _btnTestRewardedAd:Button;
		private var _btnTestNonRewardedAd:Button;
		private var _container:Sprite;
		private var _yPadding:int = 15;
		private var _offerwallScreen:OfferwallScreen;
		private var _rewardedAdScreen:PlayVideoScreen;
		private var _nonRewardedAdScreen:PlayVideoScreen;
		private var _videoNextScreen:VideoNextScreen;
		private var _txtVersion:starling.text.TextField;
		private var textFieldScreenName:flash.text.TextField;
		
		private var _isPokktReady:Boolean = false;
		private var _pokktConfig:PokktConfig;
		private var _isRewarded:Boolean = false;
		
		public function MainScreen()
		{
			super();
			
			_txtVersion = GetUIComponent.getTextField("V1.0.0", 15 * Constants.X_SCALE, false);
			_txtVersion.hAlign = HAlign.RIGHT;
			_txtVersion.color = Color.WHITE;
			_txtVersion.x = _imgLogo.x + _txtVersion.width/2; 
			_txtVersion.y = _imgLogo.y - _txtVersion.height;
			addChild(_txtVersion);
			
			textFieldScreenName = new flash.text.TextField();
			var textFormat:TextFormat = new TextFormat("Arial", 24 / Constants.ContentScaleFactor, 0x000000);
			textFormat.align = TextFormatAlign.LEFT;
			textFieldScreenName.defaultTextFormat = textFormat;
			textFieldScreenName.type = TextFieldType.INPUT;
			textFieldScreenName.width = 400 / Constants.ContentScaleFactor;
			textFieldScreenName.height = 70 / Constants.ContentScaleFactor;
			textFieldScreenName.x = 30 * Constants.X_SCALE;
			textFieldScreenName.y = _imgLogo.y + _imgLogo.height + 30 * Constants.Y_SCALE;
			textFieldScreenName.text = "start";
			Starling.current.nativeOverlay.addChild(textFieldScreenName);
			
			_btnInitPokkt = GetUIComponent.getButton(BUTTON1, "Initialise Pokkt", 10);
			_btnInitPokkt.y = textFieldScreenName.y + textFieldScreenName.height + 30 * Constants.Y_SCALE; 
			_btnInitPokkt.addEventListener(Event.TRIGGERED, onInitPokktAdClick);
			addChild(_btnInitPokkt);
			
			_btnTestRewardedAd = GetUIComponent.getButton(BUTTON1, "Test Rewarded Ad", 10);
			_btnTestRewardedAd.y = _btnInitPokkt.y + _btnInitPokkt.height + 30 * Constants.Y_SCALE; 
			_btnTestRewardedAd.addEventListener(Event.TRIGGERED, onTestRewardedAdClick);
			addChild(_btnTestRewardedAd);
			
			_btnTestNonRewardedAd = GetUIComponent.getButton(BUTTON1, "Test Non Rewarded Ad", 10);
			_btnTestNonRewardedAd.y = _btnTestRewardedAd.y + _btnTestRewardedAd.height + _yPadding / Constants.ContentScaleFactor;
			_btnTestNonRewardedAd.addEventListener(Event.TRIGGERED, onTestNonRewardedAdClick);
			addChild(_btnTestNonRewardedAd);

			_btnTestOfferwall = GetUIComponent.getButton(BUTTON2, "Test Offerwall", 10);
			_btnTestOfferwall.y = _btnTestNonRewardedAd.y + _btnTestNonRewardedAd.height + _yPadding / Constants.ContentScaleFactor;
			_btnTestOfferwall.addEventListener(Event.TRIGGERED, onTestOfferwallClick);
			if(!Constants.IS_IPHONE)
				addChild(_btnTestOfferwall);
			
			Starling.current.nativeStage.addEventListener(KeyboardEvent.KEY_DOWN, keyPressed);
			
			hideButton();
		}
		
		//Callback function
		protected function onPokktInitialised(event:PokktEvent):void
		{
			trace("onPokktInitialised called: " + event.isPokktReady);
			
			_isPokktReady = event.isPokktReady;
			if(_isPokktReady)
				showButton();
			else
				_btnInitPokkt.enabled = true;
			
			var purchaseDetails:InAppPurchaseDetail = new InAppPurchaseDetail();
			purchaseDetails.currencyCode = "IN";
			purchaseDetails.productId = "pdtId"
			purchaseDetails.description = "desc";
			purchaseDetails.currencyCode = "INR";
			purchaseDetails.price = 20;
			purchaseDetails.purchaseSignature = "signature";
			purchaseDetails.purchaseStore = IAPStoreType.AMAZON;
			purchaseDetails.title = "SampleApp";
			PokktManager.trackIAP(purchaseDetails);	
		}
		
		protected function onInitPokktAdClick(event:Event):void
		{
			_btnInitPokkt.enabled = false;
			pokktInit();
		}
		
		protected function onTestRewardedAdClick(event:Event):void
		{
			if(textFieldScreenName.text.length == 0)
			{
				PokktManager.showToast("Please enter ScreenName/PlacementID/Location");
			}
			else
			{
				_isRewarded = true;
				_rewardedAdScreen = new PlayVideoScreen(onCloseSansAutoScreen, textFieldScreenName.text, true);
				addChild(_rewardedAdScreen);
				textFieldScreenName.visible = false;
			}
		}
		
		protected function onTestNonRewardedAdClick(event:Event):void
		{
			if(textFieldScreenName.text.length == 0)
			{
				PokktManager.showToast("Please enter ScreenName/PlacementID/Location");
			}
			else
			{
				_isRewarded = false;
				_nonRewardedAdScreen = new PlayVideoScreen(onCloseSansAutoScreen, textFieldScreenName.text, false);
				addChild(_nonRewardedAdScreen);
				textFieldScreenName.visible = false;
			}
		}
		
		protected function onTestOfferwallClick(event:Event):void
		{
			textFieldScreenName.visible = false;
			_offerwallScreen = new OfferwallScreen(onCloseOfferwall);
			addChild(_offerwallScreen);
		}
		
		private function onCloseOfferwall():void
		{
			textFieldScreenName.visible = true;
			removeChild(_offerwallScreen);
			_offerwallScreen.dispose();
			_offerwallScreen = null;
		}
		
		private function hideButton():void
		{
			_btnTestNonRewardedAd.enabled = false;
			_btnTestRewardedAd.enabled = false;
			_btnTestOfferwall.enabled = false;
		}
		
		private function showButton():void
		{
			_btnTestNonRewardedAd.enabled = true;
			_btnTestRewardedAd.enabled = true;
			_btnTestOfferwall.enabled = true;
			_btnInitPokkt.enabled = false;
		}
		
		private function pokktInit():void
		{
			//Pokkt
			_pokktConfig = new PokktConfig();
			
			//videodemo 
			_pokktConfig.securityKey = "iJ02lJss0M";
			_pokktConfig.applicationId = "a2717a45b835b5e9f50284a38d62a74e";
			
			//Android- PokktSampleApp
//			_pokktConfig.securityKey = "91f118562047d230f2b907ba93d2c4e2";
//			_pokktConfig.applicationId = "4317fb1fcbf1ca98badf08ef59b0b86b";
			
			//Amit for Android:
//			_pokktConfig.securityKey = "81f2f0b8e67752ddd552f9b9e2c678f3";
//			_pokktConfig.applicationId = "0f666bc5d176ce734443a4fe00183d63";
			
			//Amit for iOS:
//			_pokktConfig.securityKey = "4a069e89fe4a4e4f58a26f8bff2974ba";
//			_pokktConfig.applicationId = "cc41e865391d6ea371b18aff27cc10e6";
			
			//iOS
//			_pokktConfig.securityKey = "ae501f1003b0dc927dea807498ceaf3c";
//			_pokktConfig.applicationId = "954b975f9c753bcb8fca42624d78139a";
			
			_pokktConfig.integrationType = PokktIntegrationType.INTEGRATION_TYPE_ALL;
			
			testOptionalMethod();
			
			PokktManager.setDebug(true);
			PokktManager.initPokkt(_pokktConfig);
			
			PokktManager.dispatcher.addEventListener(PokktEvent.POKKT_INITIALISED_EVENT, onPokktInitialised);
		}
		
		private function testOptionalMethod():void
		{
			_pokktConfig.thirdPartyUserId = "123";
			_pokktConfig.name = "Pankaj";
			_pokktConfig.age = "32";
			_pokktConfig.sex = "Male";
			_pokktConfig.birthday = "20/08/1983";
			_pokktConfig.education = "MCA";
			_pokktConfig.emailAddress = "pankaj454k@gmail.com";
			_pokktConfig.employment = "Eng";
			_pokktConfig.facebookId = "pankaj454k";
			_pokktConfig.location = "Bangalore";
			_pokktConfig.maritalStatus = "Married";
			_pokktConfig.maturityRating = "For All";
			_pokktConfig.mobileNo = "9900064040";
			_pokktConfig.nationality = "Indian";
			_pokktConfig.twitterHandle = "pankaj454k";
			_pokktConfig.selectedAnalyticsType = AnalyticsType.MIXPANEL;
			_pokktConfig.mixPanelProjectToken = "id";
			//var purchaseDetails:InAppPurchaseDetail = new InAppPurchaseDetail();
			//purchaseDetails.currencyCode = "IN";
			//purchaseDetails.description = "desc";
			//purchaseDetails.currencyCode = "";
			//purchaseDetails.currencyCode = "";
			//purchaseDetails.currencyCode = "";
			//purchaseDetails.currencyCode = "";
			//purchaseDetails.currencyCode = "";
			//PokktManager.trackIAP(purchaseDetails);
		}
		
		private function onCloseSansAutoScreen(value:Boolean = false):void
		{
			PokktManager.dispatcher.removeEventListener(PokktEvent.POKKT_INITIALISED_EVENT, onPokktInitialised);
			
			if(_rewardedAdScreen)
			{
				textFieldScreenName.visible = true;
				removeChild(_rewardedAdScreen);
				_rewardedAdScreen.dispose();
				_rewardedAdScreen = null;
			}
			
			if(_nonRewardedAdScreen)
			{
				textFieldScreenName.visible = true;
				removeChild(_nonRewardedAdScreen);
				_nonRewardedAdScreen.dispose();
				_nonRewardedAdScreen = null;
			}
			
			if(!value)
			{
				_videoNextScreen = new VideoNextScreen();
				addChild(_videoNextScreen);
			}
		}
		
		private function keyPressed(e:KeyboardEvent):void
		{    
			if(e.keyCode == Keyboard.BACK || e.keyCode == Keyboard.ESCAPE)
			{
				e.preventDefault();
				e.stopImmediatePropagation();
				
				if(_offerwallScreen != null)
				{
					onCloseOfferwall();
				}
				else if(_rewardedAdScreen != null || _nonRewardedAdScreen != null)
				{
					onCloseSansAutoScreen(true);
				}
				else if(_videoNextScreen != null)
				{
					removeChild(_videoNextScreen);
					_videoNextScreen = null;
				}
				else
				{
					NativeApplication.nativeApplication.exit();
				}
			}            
		}
		
	}
}