package
{
	import flash.desktop.NativeApplication;
	import flash.events.KeyboardEvent;
	import flash.ui.Keyboard;
	
	import starling.core.Starling;
	import starling.display.Button;
	import starling.display.Sprite;
	import starling.events.Event;
	import starling.text.TextField;
	import starling.utils.Color;
	import starling.utils.HAlign;

	public class MainScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnTestOfferwall:Button;
		private var _btnTestVideo:Button;
		private var _container:Sprite;
		private var _yPadding:int = 15;
		private var _offerwallScreen:OfferwallScreen;
		private var _sansAutoVideoScreen:PlayVideoScreen;
		private var _videoNextScreen:VideoNextScreen;
		private var _txtVersion:TextField;
		
		public function MainScreen()
		{
			super();
			
			_txtVersion = GetUIComponent.getTextField("V1.0.0", 15 * Constants.X_SCALE, false);
			_txtVersion.hAlign = HAlign.RIGHT;
			_txtVersion.color = Color.WHITE;
			_txtVersion.y = _imgLogo.y + _imgLogo.height - 20  * Constants.Y_SCALE;
			addChild(_txtVersion);
			
			_btnTestOfferwall = GetUIComponent.getButton(BUTTON2, "Test Offerwall", 10);
			_btnTestOfferwall.y = _imgLogo.y + _imgLogo.height + 30 * Constants.Y_SCALE;
			_btnTestOfferwall.addEventListener(Event.TRIGGERED, onTestOfferwallClick);
			if(!Constants.IS_IPHONE)
				addChild(_btnTestOfferwall);

			_btnTestVideo = GetUIComponent.getButton(BUTTON1, "Test Video", 10);
			_btnTestVideo.y = _btnTestOfferwall.y + _btnTestOfferwall.height + _yPadding * Constants.ContentScaleFactor;
			_btnTestVideo.addEventListener(Event.TRIGGERED, onSansAutoVideoClick);
			addChild(_btnTestVideo);
			
			Starling.current.nativeStage.addEventListener(KeyboardEvent.KEY_DOWN, keyPressed);
		}
		
		private function keyPressed(e:KeyboardEvent):void
		{    
			if(e.keyCode == Keyboard.BACK || e.keyCode == Keyboard.ESCAPE)
			{
				e.preventDefault();
				e.stopImmediatePropagation();
				
				trace("Back button is pressed");
				
				if(_offerwallScreen != null)
				{
					onCloseOfferwall();
				}
				else if(_sansAutoVideoScreen != null)
				{
					onCloseSansAutoScreen(true);
				}
				else if(_videoNextScreen != null)
				{
					removeChild(_videoNextScreen);
					_videoNextScreen = null;
				}
				else
				{
					NativeApplication.nativeApplication.exit();
				}
			}            
		}
		
		protected function onTestOfferwallClick(event:Event):void
		{
			trace(event.currentTarget);
			_offerwallScreen = new OfferwallScreen(onCloseOfferwall);
			addChild(_offerwallScreen);
		}
		
		private function onCloseOfferwall():void
		{
			removeChild(_offerwallScreen);
			_offerwallScreen.dispose();
			_offerwallScreen = null;
		}
		
		protected function onSansAutoVideoClick(event:Event):void
		{
			trace(event.currentTarget);
			_sansAutoVideoScreen = new PlayVideoScreen(onCloseSansAutoScreen);
			addChild(_sansAutoVideoScreen);
		}
		
		private function onCloseSansAutoScreen(value:Boolean = false):void
		{
			removeChild(_sansAutoVideoScreen);
			_sansAutoVideoScreen.dispose();
			_sansAutoVideoScreen = null;
			
			if(!value)
			{
				_videoNextScreen = new VideoNextScreen();
				addChild(_videoNextScreen);
			}
		}
	}
}