package
{
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.geom.Rectangle;
	
	import starling.core.Starling;
	import starling.utils.RectangleUtil;
	import starling.utils.ScaleMode;
	
	[SWF(width="480", height="800", frameRate="60", backgroundColor="#ffffff")]
	
	public class Sample_PokktSDK extends Sprite
	{
		private var _starling:Starling;
		
		private var _screenWidth:int;
		private var _screenHeight:int;
		
		private var _viewPort:Rectangle;
		
		public function Sample_PokktSDK()
		{
			if(this.stage)
			{
				this.stage.align = StageAlign.TOP_LEFT;
				this.stage.scaleMode = StageScaleMode.NO_SCALE;
			}
			
			_screenWidth = Constants.StageWidth = stage.fullScreenWidth;
			_screenHeight = Constants.StageHeight = stage.fullScreenHeight;
			
			var scaleFactor:Number = getScaleFactor();
			
			Constants.ContentScaleFactor = scaleFactor;
			
			_viewPort = RectangleUtil.fit(
				new Rectangle(0, 0, Constants.TARGET_WIDTH, Constants.TARGET_HEIGHT), 
				new Rectangle(0, 0, stage.fullScreenWidth, stage.fullScreenHeight), 
				ScaleMode.SHOW_ALL);
			Starling.handleLostContext = true;
			_starling = new Starling(Main, stage, _viewPort, null, "auto", "baseline");
			stage.addEventListener(Event.RESIZE, onStageResize);
			_starling.start();
			
			Constants.IS_IPHONE = true; //set true if running on iPhone otherwise pass false
		}
		
		private function onStageResize(event:Event):void
		{
			trace("Stage resized");
			_viewPort = RectangleUtil.fit(
				new Rectangle(0, 0, Constants.TARGET_WIDTH, Constants.TARGET_HEIGHT), 
				new Rectangle(0, 0, stage.fullScreenWidth, stage.fullScreenHeight), 
				ScaleMode.SHOW_ALL);
			_starling.viewPort = _viewPort;
		}
		
		private function getScaleFactor():Number
		{
			var widthScale:Number = _screenWidth/Constants.TARGET_WIDTH;
			var heightScale:Number = _screenHeight/Constants.TARGET_HEIGHT;
			
			var minScale:Number = Math.min(widthScale,heightScale);
			var maxScale:Number = Math.max(widthScale,heightScale);
			Constants.X_SCALE = maxScale;
			Constants.Y_SCALE = minScale;
			
			var scaleFactor:Number = Math.max(Constants.TARGET_WIDTH/_screenWidth , Constants.TARGET_HEIGHT/_screenHeight);
			return scaleFactor;
		}
	}
}