package
{
	import com.pokkt.pokktsdk.PokktEvent;
	
	import flash.desktop.NativeApplication;
	import flash.events.Event;
	import flash.text.SoftKeyboardType;
	
	import feathers.controls.Check;
	import feathers.controls.TextInput;
	import feathers.controls.text.StageTextTextEditor;
	import feathers.core.ITextEditor;
	
	import starling.display.Button;
	import starling.events.Event;
	import starling.text.TextField;

	public class OfferwallScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnGetOfferwallWithValue:Button;
		private var _btnGetOfferwallWithFixValue:Button;
		private var _btnIncompleteCall:Button;
		
		private var _txtEarnedPoint:TextField;
		private var _inputTxtMaxPoint:TextInput;
		private var _checkBox:Check;
		
		private var _yPadding:int = 15;
		
		private var _pokktManager:PokktManager;
		private var _callback:Function;
		private var _isActivateCalledAlready:Boolean = false;
		
		public function OfferwallScreen(callback:Function)
		{
			super();
			
			_callback = callback;
			_imgLogo.y = _imgLogo.y/2;
			
			_txtEarnedPoint = GetUIComponent.getTextField("Points earned: 0", 20 * Constants.X_SCALE, false);
			_txtEarnedPoint.x = 10 * Constants.X_SCALE;
			_txtEarnedPoint.y = _imgLogo.y  +_imgLogo.height;
			addChild(_txtEarnedPoint);
			
			_btnGetOfferwallWithValue = GetUIComponent.getButton(BUTTON1, "Get offer wall(Any asset value)", 10);
			_btnGetOfferwallWithValue.y = _txtEarnedPoint.y + _txtEarnedPoint.height + 30 * Constants.Y_SCALE;
			_btnGetOfferwallWithValue.addEventListener(starling.events.Event.TRIGGERED, onGetOfferwallWithValueClick);
			addChild(_btnGetOfferwallWithValue);
			
			_inputTxtMaxPoint = new TextInput();
			_inputTxtMaxPoint.x = 10 * Constants.X_SCALE;
			_inputTxtMaxPoint.y = _btnGetOfferwallWithValue.y + _btnGetOfferwallWithValue.height + _yPadding * Constants.Y_SCALE;
			_inputTxtMaxPoint.restrict = "0-9";
			_inputTxtMaxPoint.textEditorFactory = function ():ITextEditor
			{
				var stte:StageTextTextEditor = new StageTextTextEditor();
				stte.softKeyboardType = SoftKeyboardType.NUMBER;
				return stte;
			};
			_inputTxtMaxPoint.text = "0";
			addChild(_inputTxtMaxPoint);
			
			_btnGetOfferwallWithFixValue = GetUIComponent.getButton(BUTTON2, "Get Offerwall(Fix assets value)", 10);
			_btnGetOfferwallWithFixValue.y = _btnGetOfferwallWithValue.y + (_btnGetOfferwallWithValue.height*2) + _yPadding * Constants.Y_SCALE;
			_btnGetOfferwallWithFixValue.addEventListener(starling.events.Event.TRIGGERED, onGetOfferwallWithFixValueClick);
			addChild(_btnGetOfferwallWithFixValue);
			
			_btnIncompleteCall = GetUIComponent.getButton(BUTTON1, "Incomplete call back", 10);
			_btnIncompleteCall.y = _btnGetOfferwallWithFixValue.y + _btnGetOfferwallWithFixValue.height + _yPadding * Constants.Y_SCALE;
			_btnIncompleteCall.addEventListener(starling.events.Event.TRIGGERED, onIncompleteCallClick);
			addChild(_btnIncompleteCall);
			
			_checkBox = new Check();
			_checkBox.x = 10 * Constants.X_SCALE;
			_checkBox.y = _btnIncompleteCall.y + _btnIncompleteCall.height + _yPadding * Constants.Y_SCALE;
			_checkBox.isSelected = false;
			_checkBox.label = "Close on Success Flag";
			_checkBox.addEventListener(starling.events.Event.CHANGE, toggle_changeHandler);
			addChild(_checkBox);
			
			//
			_pokktManager = PokktManager.getInstance();
			_pokktManager.createExtension();
			_pokktManager.setDebug(true);
			_pokktManager.initPokkt();
			_pokktManager.addEventListener(PokktEvent.COIN_RESPONSE_EVENTS, onCoinResponseSuccess);
			_pokktManager.addEventListener(PokktEvent.COIN_RESPONSE_WITH_TRANS_ID_EVENTS, onCoinResponseWithTransID);
			_pokktManager.addEventListener(PokktEvent.COIN_RESPONSE_FAILED_EVENTS, onCoinResponseFailed);
			_pokktManager.addEventListener(PokktEvent.OFFERWALL_CAMPAIGN_AVAILABLITY_EVENT, onOfferwallAvailability);
			_pokktManager.addEventListener(PokktEvent.OFFERWALL_CLOSE_EVENT, onOfferwallClosed);
			
			NativeApplication.nativeApplication.addEventListener(flash.events.Event.ACTIVATE, onActivate, false, 0, true);
			NativeApplication.nativeApplication.addEventListener(flash.events.Event.DEACTIVATE, onDeactivate, false, 0, true);
		}
		
		protected function onOfferwallClosed(event:PokktEvent):void
		{
			trace(event);
		}
		
		protected function onOfferwallAvailability(event:PokktEvent):void
		{
			trace("Offerwall availability: " + event.value);
		}
		
		protected function onDeactivate(event:flash.events.Event):void
		{
			trace("onDeactivate");
			_isActivateCalledAlready = false;
		}
		
		protected function onActivate(event:flash.events.Event):void
		{
			trace("onActivate: " + _isActivateCalledAlready);
			//Checking this condition because onActivate is calling two times sometimes.
			//Don't know the reason. Need to go in deep. Meanwhile keeping condition check here.
			if(!_isActivateCalledAlready)
			{
				_pokktManager.checkTransaction();
				_pokktManager.IsOfferwallCampaignAvailable();
				if(_checkBox.isSelected) _callback.call();
			}
			_isActivateCalledAlready = true;
		}
		
		//PokktManager callback function
		protected function onCoinResponseWithTransID(event:PokktEvent):void
		{
			var finalValue:Array = event.value.split(",");
			trace("PokktSDK: onCoinResponseWithTransID: Transaction ID: " + finalValue[0] + " and Earned points: " + finalValue[1]);
		}
		
		private function onCoinResponseSuccess(event:PokktEvent):void
		{
			trace("PokktSDK: onCoinResponseSuccess: " + event.value);
		}
		
		private function onCoinResponseFailed(event:PokktEvent):void
		{
			trace("PokktSDK: onCoinResponseFailed");
		}
		
		//button/toggle click handler
		private function toggle_changeHandler(event:starling.events.Event):void
		{
			trace(_checkBox.isSelected);
		}
		
		protected function onGetOfferwallWithValueClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			_pokktManager.getFreeCoins();
		}
		
		protected function onGetOfferwallWithFixValueClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			_pokktManager.getFixedFreeCoins(_inputTxtMaxPoint.text);
		}
		
		protected function onIncompleteCallClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			_pokktManager.getPendingCoins();
		}
		
		override public function dispose():void
		{
			super.dispose();
			_pokktManager.removeEventListener(PokktEvent.COIN_RESPONSE_EVENTS, onCoinResponseSuccess);
			_pokktManager.removeEventListener(PokktEvent.COIN_RESPONSE_WITH_TRANS_ID_EVENTS, onCoinResponseWithTransID);
			_pokktManager.removeEventListener(PokktEvent.COIN_RESPONSE_FAILED_EVENTS, onCoinResponseFailed);
			_pokktManager.removeEventListener(PokktEvent.OFFERWALL_CAMPAIGN_AVAILABLITY_EVENT, onOfferwallAvailability);
			_pokktManager.removeEventListener(PokktEvent.OFFERWALL_CLOSE_EVENT, onOfferwallClosed);
			NativeApplication.nativeApplication.removeEventListener(flash.events.Event.ACTIVATE, onActivate);
			NativeApplication.nativeApplication.removeEventListener(flash.events.Event.DEACTIVATE, onDeactivate);
		}
	}
}



/*ti.textEditorFactory = function ():ITextEditor
{
	var stte:StageTextTextEditor = new StageTextTextEditor();
	stte.softKeyboardType = SoftKeyboardType.NUMBER;
	return stte;
};*/