package
{
	import starling.display.Image;
	import starling.display.Sprite;
	
	public class BaseScreen extends Sprite
	{
		// Embed the texture:
		[Embed(source="assets/pokkt_logo.png")]
		public static const Logo:Class;
		
		[Embed(source="assets/bg.png")]
		public static const BG:Class;
		
		protected var _imgLogo:Image;
		
		public function BaseScreen()
		{
			super();
			
			var imgBg:Image = GetUIComponent.GetImage(new BG(), 0, 0);
			imgBg.width = Constants.StageWidth;
			imgBg.height = Constants.StageHeight;
			addChild(imgBg);
			
			_imgLogo = GetUIComponent.GetImage(new Logo(), 0,0);
			_imgLogo.x = Constants.StageWidth/2 - _imgLogo.width/2;
			_imgLogo.y = Constants.StageHeight/2 - _imgLogo.height*2;
			addChild(_imgLogo);
		}
	}
}