package
{
	import com.pokkt.plugin.AdConfig;
	import com.pokkt.plugin.InAppPurchaseDetail;
	import com.pokkt.plugin.PokktConfig;
	import com.pokkt.plugin.PokktManager;
	import com.pokkt.plugin.utilities.AnalyticsType;
	import com.pokkt.plugin.utilities.IAPStoreType;
	import com.pokkt.plugin.utilities.PokktEvent;
	import com.pokkt.plugin.utilities.PokktIntegrationType;
	
	import flash.display.StageAspectRatio;
	
	import starling.display.Button;
	import starling.events.Event;
	import starling.text.TextField;
	
	public class PlayVideoScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnStartCaching:Button;
		private var _btnShowAd:Button;
		private var _btnExportLogs:Button;
		private var _txtEarnedPoint:TextField;
		private var _txtInfo:TextField;
		private var _txtScreenName:TextField;
		private var _yPadding:int = 15;
		private var _totalEarnedPoint:Number = 0.0;
		private var _callback:Function;
		
		private var _pokktConfig:PokktConfig;
		private var _isPokktReady:Boolean = false;
		private var _screenName:String = "";
		private var _isRewarded:Boolean = false;
		private var _adConfig:AdConfig;
		
		public function PlayVideoScreen(callback:Function, screenName:String, isRewarded:Boolean)
		{
			super();
			
			_callback = callback;
			_screenName = screenName;
			_isRewarded = isRewarded;
			
			_imgLogo.y = _imgLogo.y/2;
			
			_txtScreenName = GetUIComponent.getTextField("Points earned: 0", 18 / Constants.ContentScaleFactor, false);
			_txtScreenName.x = 10 * Constants.X_SCALE;
			_txtScreenName.y = _imgLogo.y  +_imgLogo.height;
			_txtScreenName.text = screenName;
			addChild(_txtScreenName); 
			
			_txtEarnedPoint = GetUIComponent.getTextField("Points earned: 0", 18 / Constants.ContentScaleFactor, false);
			_txtEarnedPoint.x = 10 * Constants.X_SCALE;
			_txtEarnedPoint.y = _txtScreenName.y  +_txtScreenName.height;
			addChild(_txtEarnedPoint);
			
			_txtInfo = GetUIComponent.getTextField("You'll see button once caching is completed.", 13 / Constants.ContentScaleFactor, false);
			_txtInfo.x = 10 * Constants.X_SCALE;
			_txtInfo.y = _txtEarnedPoint.y  +_txtEarnedPoint.height + _yPadding/2 * Constants.Y_SCALE;
			addChild(_txtInfo);
			
			_btnStartCaching = GetUIComponent.getButton(BUTTON1, "Start Caching", 10);
			_btnStartCaching.y = _txtInfo.y + _txtInfo.height + _yPadding * Constants.Y_SCALE;
			_btnStartCaching.addEventListener(Event.TRIGGERED, onStartCachingClick);
			addChild(_btnStartCaching);
			
			var btnTxt:String = "";
			
			if(_isRewarded) btnTxt = "Show Non-Rewarded (without caching)"; 
			else btnTxt = "Show Rewarded (without caching)";
			
			_btnShowAd = GetUIComponent.getButton(BUTTON1, btnTxt, 10);
			_btnShowAd.y = _btnStartCaching.y + _btnStartCaching.height + _yPadding * Constants.Y_SCALE;
			_btnShowAd.addEventListener(Event.TRIGGERED, onShowAdClicked);
			addChild(_btnShowAd);
			
			_btnExportLogs = GetUIComponent.getButton(BUTTON2, "Export Logs", 10);
			_btnExportLogs.y = _btnShowAd.y + _btnShowAd.height + _yPadding * Constants.Y_SCALE;
			addChild(_btnExportLogs);
			_btnExportLogs.addEventListener(Event.TRIGGERED, onExportLogsClicked);
			
			//Pokkt
			_pokktConfig = new PokktConfig();
			
			//videodemo 
			_pokktConfig.securityKey = "iJ02lJss0M";
			_pokktConfig.applicationId = "a2717a45b835b5e9f50284a38d62a74e";
			
			//Android- PokktSampleApp
//			_pokktConfig.securityKey = "91f118562047d230f2b907ba93d2c4e2";
//			_pokktConfig.applicationId = "4317fb1fcbf1ca98badf08ef59b0b86b";
			
			//iOS
//			_pokktConfig.securityKey = "ae501f1003b0dc927dea807498ceaf3c";
//			_pokktConfig.applicationId = "954b975f9c753bcb8fca42624d78139a";
			
			_pokktConfig.integrationType = PokktIntegrationType.INTEGRATION_TYPE_ALL;
			
			testOptionalMethod();
			
			PokktManager.setDebug(true);
			
			PokktManager.dispatcher.addEventListener(PokktEvent.POKKT_INITIALISED_EVENT, onPokktInitialised);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_AVAILABILITY_STATUS_EVENT, onAdAvailability);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_CACHING_COMPLETED_EVENTS, onAdCachingCompleted);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_CACHING_FAILED_EVENTS, onAdCachingFailed);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_CLOSED_EVENTS, onAdClosed);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_COMPLETED_EVENTS, onAdCompleted);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_SKIPPED_EVENTS, onAdSkipped);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_DISPLAYED_EVENTS, onAdDisplayed);
			PokktManager.dispatcher.addEventListener(PokktEvent.AD_GRATIFIED_EVENTS, onAdGratified);

			PokktManager.initPokkt(_pokktConfig);			
		}
		
		private function testOptionalMethod():void
		{
			_pokktConfig.thirdPartyUserId = "123";
			_pokktConfig.name = "Pankaj";
			_pokktConfig.age = "32";
			_pokktConfig.sex = "Male";
			_pokktConfig.birthday = "20/08/1983";
			_pokktConfig.education = "MCA";
			_pokktConfig.emailAddress = "pankaj454k@gmail.com";
			_pokktConfig.employment = "Eng";
			_pokktConfig.facebookId = "pankaj454k";
			_pokktConfig.location = "Bangalore";
			_pokktConfig.maritalStatus = "Married";
			_pokktConfig.maturityRating = "For All";
			_pokktConfig.mobileNo = "9900064040";
			_pokktConfig.nationality = "Indian";
			_pokktConfig.twitterHandle = "pankaj454k";
			_pokktConfig.selectedAnalyticsType = AnalyticsType.MIXPANEL;
			_pokktConfig.mixPanelProjectToken = "id";
			
//			var purchaseDetails:InAppPurchaseDetail = new InAppPurchaseDetail();
//			purchaseDetails.currencyCode = "IN";
//			purchaseDetails.description = "desc";
//			purchaseDetails.currencyCode = "";
//			purchaseDetails.currencyCode = "";
//			purchaseDetails.currencyCode = "";
//			purchaseDetails.currencyCode = "";
//			purchaseDetails.currencyCode = "";
//			PokktManager.trackIAP(purchaseDetails);
		}
		
		private function showButton(rewardValue:Number, isAdAvailable:Boolean, adConfig:AdConfig):void
		{
			if(isAdAvailable) 
			{
				if(_isRewarded)
				{
					_btnShowAd.text = "Show Incent Ad To Earn " + rewardValue + " (Caching)";
				} 
				else
				{
					_btnShowAd.text = "Show Non-Incent Ad To Earn " + rewardValue + " (Caching)";
				}
			}
		}
		
		private function resetButton():void
		{
			var btnTxt:String;
			if(_isRewarded) btnTxt = "Show Non-Rewarded (without caching)"; 
			else btnTxt = "Show Rewarded (without caching)";
			_btnShowAd.text = btnTxt;
		}
		
		private function showAd(isAdAvailable:Boolean, adConfig:AdConfig):void
		{
			if(isAdAvailable)
			{
				if(_isPokktReady)
					PokktManager.showAd(adConfig);
				else
					PokktManager.showToast("Pokkt SDK is not ready.");
			}
		}
		
		//Button click functions
		
		protected function onStartCachingClick(event:Event):void
		{
			_adConfig = new AdConfig();
			_adConfig.screenName = _screenName;
			_adConfig.isRewarded = _isRewarded;
			_adConfig.defaultSkipTime = 5;
			_adConfig.backButtonDisabled = false;
			PokktManager.cacheAd(_adConfig); 
		}
		
		protected function onShowAdClicked(event:starling.events.Event):void
		{
			if(!_adConfig)
			{
				_adConfig = new AdConfig();
				_adConfig.screenName = _screenName;
				_adConfig.isRewarded = _isRewarded;
				_adConfig.defaultSkipTime = 5;
				_adConfig.backButtonDisabled = false;
			}
			PokktManager.checkAdAvailability(_adConfig);
		}
		
		private function onExportLogsClicked():void
		{
			PokktManager.exportLog();
		}
		
		
		//Callback function
		protected function onPokktInitialised(event:PokktEvent):void
		{
			trace("onPokktInitialised called: " + event.isPokktReady);
			_isPokktReady = event.isPokktReady;
			var purchaseDetails:InAppPurchaseDetail = new InAppPurchaseDetail();
			purchaseDetails.currencyCode = "IN";
			purchaseDetails.productId = "pdtId"
			purchaseDetails.description = "desc";
			purchaseDetails.currencyCode = "INR";
			purchaseDetails.price = 20;
			purchaseDetails.purchaseSignature = "signature";
			purchaseDetails.purchaseStore = IAPStoreType.AMAZON;
			purchaseDetails.title = "SampleApp";
			PokktManager.trackIAP(purchaseDetails);

		}

		protected function onAdCachingCompleted(event:PokktEvent):void
		{
			trace(event.adConfig);
			showButton(event.rewardValue, event.isAdAvailable, event.adConfig);
		}
		
		protected function onAdCachingFailed(event:PokktEvent):void
		{
			trace(event.adConfig);
			showButton(event.rewardValue, event.isAdAvailable, event.adConfig);
			resetButton();
		}
		
		protected function onAdAvailability(event:PokktEvent):void
		{
			trace("onAdAvailability called: " + event.isAdAvailable);
			showButton(event.rewardValue, event.isAdAvailable, event.adConfig);
			showAd(event.isAdAvailable, event.adConfig);
		}
		
		protected function onAdGratified(event:PokktEvent):void
		{
			trace("onAdGratified");
			_totalEarnedPoint = _totalEarnedPoint + event.rewardValue;
			_txtEarnedPoint.text = "Points earned: "  + _totalEarnedPoint;
		}
		
		protected function onAdDisplayed(event:PokktEvent):void
		{
			//Constants.STAGE.setAspectRatio(StageAspectRatio.LANDSCAPE);
			trace("onAdDisplayed ", event.adConfig);
		}
		
		protected function onAdSkipped(event:PokktEvent):void
		{
			trace("onAdSkipped");
		}
		
		protected function onAdCompleted(event:PokktEvent):void
		{
			trace("onAdCompleted");
		}
		
		protected function onAdClosed(event:PokktEvent):void
		{
			Constants.STAGE.setAspectRatio( StageAspectRatio.PORTRAIT );
			resetButton();
		}
		
		//Dispose method
		override public function dispose():void
		{
			super.dispose();
			PokktManager.dispatcher.removeEventListener(PokktEvent.POKKT_INITIALISED_EVENT, onPokktInitialised);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_AVAILABILITY_STATUS_EVENT, onAdAvailability);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_CACHING_COMPLETED_EVENTS, onAdCachingCompleted);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_CACHING_FAILED_EVENTS, onAdCachingFailed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_CLOSED_EVENTS, onAdClosed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_COMPLETED_EVENTS, onAdCompleted);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_SKIPPED_EVENTS, onAdSkipped);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_DISPLAYED_EVENTS, onAdDisplayed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.AD_GRATIFIED_EVENTS, onAdGratified);
		}
	}
}