package
{	
	import com.pokkt.plugin.PokktManager;
	
	import flash.desktop.NativeApplication;
	import flash.events.KeyboardEvent;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	import flash.text.TextFormat;
	import flash.text.TextFormatAlign;
	import flash.ui.Keyboard;
	
	import starling.core.Starling;
	import starling.display.Button;
	import starling.display.Sprite;
	import starling.events.Event;
	import starling.text.TextField;
	import starling.utils.Color;
	import starling.utils.HAlign;

	public class MainScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnTestOfferwall:Button;
		private var _btnTestRewardedAd:Button;
		private var _btnTestNonRewardedAd:Button;
		private var _container:Sprite;
		private var _yPadding:int = 15;
		private var _offerwallScreen:OfferwallScreen;
		private var _rewardedAdScreen:PlayVideoScreen;
		private var _nonRewardedAdScreen:PlayVideoScreen;
		private var _videoNextScreen:VideoNextScreen;
		private var _txtVersion:starling.text.TextField;
		private var textField:flash.text.TextField;
		
		public function MainScreen()
		{
			super();
			
			_txtVersion = GetUIComponent.getTextField("V1.0.0", 15 * Constants.X_SCALE, false);
			_txtVersion.hAlign = HAlign.RIGHT;
			_txtVersion.color = Color.WHITE;
			_txtVersion.x = _imgLogo.x + _txtVersion.width/2; 
			_txtVersion.y = _imgLogo.y - _txtVersion.height;
			addChild(_txtVersion);
			
			textField = new flash.text.TextField();
			// Create default text format
			var textFormat:TextFormat = new TextFormat("Arial", 24 / Constants.ContentScaleFactor, 0x000000);
			textFormat.align = TextFormatAlign.LEFT;
			textField.defaultTextFormat = textFormat;
			// Set text input type
			textField.type = TextFieldType.INPUT;
			//textField.autoSize = TextFieldAutoSize.LEFT;
			textField.width = 400 / Constants.ContentScaleFactor;
			textField.height = 70 / Constants.ContentScaleFactor;
			textField.x = 30 * Constants.X_SCALE;
			textField.y = _imgLogo.y + _imgLogo.height + 30 * Constants.Y_SCALE;
//			textField.background = true;
//			textField.backgroundColor = 0xffffff;
			textField.text = "start";
			Starling.current.nativeOverlay.addChild(textField);

			
			_btnTestRewardedAd = GetUIComponent.getButton(BUTTON1, "Test Rewarded Ad", 10);
			_btnTestRewardedAd.y = textField.y + textField.height + 30 * Constants.Y_SCALE; 
			_btnTestRewardedAd.addEventListener(Event.TRIGGERED, onTestRewardedAdClick);
			addChild(_btnTestRewardedAd);
			
			_btnTestNonRewardedAd = GetUIComponent.getButton(BUTTON1, "Test Non Rewarded Ad", 10);
			_btnTestNonRewardedAd.y = _btnTestRewardedAd.y + _btnTestRewardedAd.height + _yPadding / Constants.ContentScaleFactor;
			_btnTestNonRewardedAd.addEventListener(Event.TRIGGERED, onTestNonRewardedAdClick);
			addChild(_btnTestNonRewardedAd);

			_btnTestOfferwall = GetUIComponent.getButton(BUTTON2, "Test Offerwall", 10);
			_btnTestOfferwall.y = _btnTestNonRewardedAd.y + _btnTestNonRewardedAd.height + _yPadding / Constants.ContentScaleFactor;
			_btnTestOfferwall.addEventListener(Event.TRIGGERED, onTestOfferwallClick);
			if(!Constants.IS_IPHONE)
				addChild(_btnTestOfferwall);
			
			Starling.current.nativeStage.addEventListener(KeyboardEvent.KEY_DOWN, keyPressed);
		}
		
		private function keyPressed(e:KeyboardEvent):void
		{    
			if(e.keyCode == Keyboard.BACK || e.keyCode == Keyboard.ESCAPE)
			{
				e.preventDefault();
				e.stopImmediatePropagation();
				
				trace("Back button is pressed");
				
				if(_offerwallScreen != null)
				{
					onCloseOfferwall();
				}
				else if(_rewardedAdScreen != null || _nonRewardedAdScreen != null)
				{
					onCloseSansAutoScreen(true);
				}
				else if(_videoNextScreen != null)
				{
					removeChild(_videoNextScreen);
					_videoNextScreen = null;
				}
				else
				{
					NativeApplication.nativeApplication.exit();
				}
			}            
		}
		
		protected function onTestOfferwallClick(event:Event):void
		{
			_offerwallScreen = new OfferwallScreen(onCloseOfferwall);
			addChild(_offerwallScreen);
		}
		
		private function onCloseOfferwall():void
		{
			removeChild(_offerwallScreen);
			_offerwallScreen.dispose();
			_offerwallScreen = null;
		}
		
		protected function onTestRewardedAdClick(event:Event):void
		{
			if(textField.text.length == 0)
			{
				PokktManager.showToast("Please enter ScreenName/PlacementID/Location");
			}
			else
			{
					_rewardedAdScreen = new PlayVideoScreen(onCloseSansAutoScreen, textField.text, true);
					addChild(_rewardedAdScreen);
					textField.visible = false;
			}
		}
		
		protected function onTestNonRewardedAdClick(event:Event):void
		{
			if(textField.text.length == 0)
			{
				PokktManager.showToast("Please enter ScreenName/PlacementID/Location");
			}
			else
			{
				_nonRewardedAdScreen = new PlayVideoScreen(onCloseSansAutoScreen, textField.text, false);
				addChild(_nonRewardedAdScreen);
				textField.visible = false;
			}
		}
		
		private function onCloseSansAutoScreen(value:Boolean = false):void
		{
			if(_rewardedAdScreen)
			{
				textField.visible = true;
				removeChild(_rewardedAdScreen);
				_rewardedAdScreen.dispose();
				_rewardedAdScreen = null;
			}
			
			if(_nonRewardedAdScreen)
			{
				textField.visible = true;
				removeChild(_nonRewardedAdScreen);
				_nonRewardedAdScreen.dispose();
				_nonRewardedAdScreen = null;
			}
			
			if(!value)
			{
				_videoNextScreen = new VideoNextScreen();
				addChild(_videoNextScreen);
			}
		}
		
	}
}