package
{
	import com.pokkt.pokktsdk.AnalyticsType;
	import com.pokkt.pokktsdk.PokktConfig;
	import com.pokkt.pokktsdk.PokktEvent;
	import com.pokkt.pokktsdk.PokktIntegrationType;
	import com.pokkt.pokktsdk.PokktManager;
	
	import flash.display.StageAspectRatio;
	
	import starling.core.Starling;
	import starling.display.Button;
	import starling.events.Event;
	import starling.text.TextField;

	public class PlayVideoScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnStartCaching:Button;
		private var _btnPlayIncentVdo:Button;
		private var _btnPlayNonIncentVdo:Button;
		private var _btnWithUserIntent:Button;
		private var _txtEarnedPoint:TextField;
		private var _txtInfo:TextField;
		
		private var _yPadding:int = 15;
		
		private var _totalEarnedPoint:int;
		
		private var _callback:Function;
		
		private var _pokktConfig:PokktConfig;
		
		public function PlayVideoScreen(callback:Function)
		{
			super();
			
			_callback = callback;
			
			_imgLogo.y = _imgLogo.y/2;
			
			_txtEarnedPoint = GetUIComponent.getTextField("Points earned: 0", 20 * Constants.X_SCALE, false);
			_txtEarnedPoint.x = 10 * Constants.X_SCALE;
			_txtEarnedPoint.y = _imgLogo.y  +_imgLogo.height;
			addChild(_txtEarnedPoint);
			
			_txtInfo = GetUIComponent.getTextField("Getting Vdo Campaign. Button will get enable after caching Video.", 15 * Constants.X_SCALE, false);
			_txtInfo.x = 10 * Constants.X_SCALE;
			_txtInfo.y = _txtEarnedPoint.y  +_txtEarnedPoint.height + _yPadding/2 * Constants.Y_SCALE;
			addChild(_txtInfo);
			
			_btnStartCaching = GetUIComponent.getButton(BUTTON1, "Start Caching", 10);
			_btnStartCaching.y = _txtInfo.y + _txtInfo.height + _yPadding * Constants.Y_SCALE;
			_btnStartCaching.addEventListener(Event.TRIGGERED, onStartCachingClick);
			if(!Storage.AutoCacheVideo)
				addChild(_btnStartCaching);
			
			_btnPlayIncentVdo = GetUIComponent.getButton(BUTTON1, "Play Incent Vdo To Earn", 10);
			_btnPlayIncentVdo.y = _btnStartCaching.y + _btnStartCaching.height + _yPadding * Constants.Y_SCALE;
			_btnPlayIncentVdo.addEventListener(Event.TRIGGERED, onPlayIncentVdoClick);
			addChild(_btnPlayIncentVdo);
			
			_btnPlayNonIncentVdo = GetUIComponent.getButton(BUTTON2, "Play Non-Incent Vdo", 10);
			_btnPlayNonIncentVdo.y = _btnPlayIncentVdo.y + _btnPlayIncentVdo.height + _yPadding * Constants.Y_SCALE;
			_btnPlayNonIncentVdo.addEventListener(Event.TRIGGERED, onPlayNonIncentVdoClick);
			addChild(_btnPlayNonIncentVdo);
			
			_btnWithUserIntent = GetUIComponent.getButton(BUTTON2, "With User Intent Vdo", 10);
			_btnWithUserIntent.y = _btnPlayNonIncentVdo.y + _btnPlayNonIncentVdo.height + _yPadding * Constants.Y_SCALE;
			
			//Pokkt
			_pokktConfig = new PokktConfig();
			_pokktConfig.securityKey = "iJ02lJss0M";
			_pokktConfig.applicationId = "a2717a45b835b5e9f50284a38d62a74e";
			_pokktConfig.integrationType = PokktIntegrationType.INTEGRATION_TYPE_ALL;
			_pokktConfig.autoCacheVideo = Storage.AutoCacheVideo;
			PokktManager.setDebug(true);
			PokktManager.initPokkt(_pokktConfig);
			_pokktConfig.skipEnabled = true;
			_pokktConfig.defaultSkipTime = 5;
			_pokktConfig.customSkipMessage = "Are you sure?";
			_pokktConfig.thirdPartyUserId = "123";
			_pokktConfig.backButtonDisabled = false;
			
			testOptionalMethod();
			
			//PokktManager.sendAppInfo();
			
			PokktManager.dispatcher.addEventListener(PokktEvent.DOWNLOAD_COMPLETED_EVENTS, onDownloadCompleted);
			PokktManager.dispatcher.addEventListener(PokktEvent.DOWNLOAD_FAILED_EVENTS, onDownloadFailed);
			PokktManager.dispatcher.addEventListener(PokktEvent.VIDEO_CLOSED_EVENTS, onVideoClosed);
			PokktManager.dispatcher.addEventListener(PokktEvent.VIDEO_COMPLETED_EVENTS, onVideoCompleted);
			PokktManager.dispatcher.addEventListener(PokktEvent.VIDEO_SKIPPED_EVENTS, onVideoSkipped);
			PokktManager.dispatcher.addEventListener(PokktEvent.VIDEO_DISPLAYED_EVENTS, onVideoDisplayed);
			PokktManager.dispatcher.addEventListener(PokktEvent.VIDEO_GRATIFIED_EVENTS, onVideoGratified);
						
			disableButton();
		}
		
		private function testOptionalMethod():void
		{
			_pokktConfig.name = "Pankaj";
			_pokktConfig.age = "32";
			_pokktConfig.sex = "Male";
			_pokktConfig.birthday = "20/08/1983";
			_pokktConfig.education = "MCA";
			_pokktConfig.emailAddress = "pankaj454k@gmail.com";
			_pokktConfig.employment = "Eng";
			_pokktConfig.facebookId = "pankaj454k";
			_pokktConfig.location = "Bangalore";
			_pokktConfig.maritalStatus = "Married";
			_pokktConfig.maturityRating = "For All";
			_pokktConfig.mobileNo = "9900064040";
			_pokktConfig.nationality = "Indian";
			_pokktConfig.twitterHandle = "pankaj454k";
			
			_pokktConfig.selectedAnalyticsType = AnalyticsType.NONE;
			//_pokktConfig.flurryApplicationKey = "1234567";
			//_pokktConfig.mixPanelProjectToken = "1234567";
			//_pokktConfig.googleAnalyticsID = "1234567";
		}
		
		private function disableButton():void
		{
			_btnPlayIncentVdo.enabled = false;
			_btnPlayNonIncentVdo.enabled = false;
			_btnStartCaching.enabled = true;
			//_btnWithUserIntent.enabled = false;
		}
		
		private function enableButton():void
		{
			_btnPlayIncentVdo.enabled = true;
			_btnPlayNonIncentVdo.enabled = true;
			_btnStartCaching.enabled = false;
			//_btnWithUserIntent.enabled = true;
		}
		
		//Callback functions
		protected function onVideoGratified(event:PokktEvent):void
		{
			trace("onVideoGratified");
			_totalEarnedPoint = _totalEarnedPoint + int(event.value);
			_txtEarnedPoint.text = "Points earned: "  + _totalEarnedPoint;
			//disableButton();
		}
		
		protected function onVideoDisplayed(event:PokktEvent):void
		{
			trace("onVideoDisplayed");
			disableButton();
		}
		
		protected function onVideoSkipped(event:PokktEvent):void
		{
			trace("onVideoSkipped");
			disableButton();
		}
		
		protected function onVideoCompleted(event:PokktEvent):void
		{
			trace("onVideoCompleted");
			disableButton();
		}
		
		protected function onVideoClosed(event:PokktEvent):void
		{
			Constants.STAGE.setAspectRatio( StageAspectRatio.PORTRAIT );
			trace("onVideoClosed");
			var star:Starling = Starling.current;
			trace(star);
			disableButton();
		}
		
		protected function onDownloadCompleted(event:PokktEvent):void
		{
			trace("onDownloadCompleted");
			enableButton();
		}
		
		protected function onDownloadFailed(event:PokktEvent):void
		{
			trace("onDownloadFailed");
			disableButton();
		}
		
		//click listener
		protected function onStartCachingClick(event:Event):void
		{
			trace(event.currentTarget);
			PokktManager.cacheVideoCampaign();
		}
		
		//Button click functions
		protected function onPlayIncentVdoClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			if(PokktManager.isVideoAvailable())
			{
				Constants.STAGE.setAspectRatio( StageAspectRatio.LANDSCAPE );
				_pokktConfig.screenName = "defaultScreen";
				PokktManager.getVideo(_pokktConfig);
			}
			else
			{
				PokktManager.showToast("Video campaign is not available");
			}
		}
		
		protected function onPlayNonIncentVdoClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			if(PokktManager.isVideoAvailable())
			{
				Constants.STAGE.setAspectRatio( StageAspectRatio.LANDSCAPE );
				_pokktConfig.screenName = "defaultScreen";
				PokktManager.getVideoNonIncent(_pokktConfig);
			}
			else
			{
				PokktManager.showToast("Video campaign is not available");
			}
		}
		
		override public function dispose():void
		{
			super.dispose();
			PokktManager.dispatcher.removeEventListener(PokktEvent.DOWNLOAD_COMPLETED_EVENTS, onDownloadCompleted);
			PokktManager.dispatcher.removeEventListener(PokktEvent.DOWNLOAD_FAILED_EVENTS, onDownloadFailed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.VIDEO_CLOSED_EVENTS, onVideoClosed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.VIDEO_COMPLETED_EVENTS, onVideoCompleted);
			PokktManager.dispatcher.removeEventListener(PokktEvent.VIDEO_SKIPPED_EVENTS, onVideoSkipped);
			PokktManager.dispatcher.removeEventListener(PokktEvent.VIDEO_DISPLAYED_EVENTS, onVideoDisplayed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.VIDEO_GRATIFIED_EVENTS, onVideoGratified);
		}
	}
}