package
{
	import starling.display.Button;
	import starling.events.Event;
	import starling.text.TextField;

	public class SelectorScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnAutoCache:Button;
		private var _btnSansAutoCache:Button;
		private var _txtInfo:TextField;
		private var _yPadding:int = 15;
		
		public function SelectorScreen()
		{
			super();
			
			_txtInfo = GetUIComponent.getTextField("Points earned: 0", 20 * Constants.X_SCALE, false);
			_txtInfo.x = 10 * Constants.X_SCALE;
			_txtInfo.y = _imgLogo.y  +_imgLogo.height;
			addChild(_txtInfo);
			
			_btnAutoCache = GetUIComponent.getButton(BUTTON2, "Auto Cache Video", 10);
			_btnAutoCache.y = _txtInfo.y + _txtInfo.height + 30 * Constants.Y_SCALE;
			_btnAutoCache.addEventListener(Event.TRIGGERED, onAutoCacheSelection);
			addChild(_btnAutoCache);
			
			_btnSansAutoCache = GetUIComponent.getButton(BUTTON1, "Sans Auto Cache Video", 10);
			_btnSansAutoCache.y = _btnAutoCache.y + _btnAutoCache.height + _yPadding * Constants.ContentScaleFactor;
			_btnSansAutoCache.addEventListener(Event.TRIGGERED, onSansCacheSelection);
			addChild(_btnSansAutoCache);
		}
		
		private function onSansCacheSelection(event:Event):void
		{
			Storage.AutoCacheVideo = false;
			loadMainScreen();
		}
		
		private function onAutoCacheSelection(event:Event):void
		{
			Storage.AutoCacheVideo = true;
			loadMainScreen();
		}
		
		private function loadMainScreen():void
		{
			var mainScreen:MainScreen = new MainScreen();
			addChild(mainScreen);
		}
	}
}