package
{
	import com.pokkt.pokktsdk.PokktConfig;
	import com.pokkt.pokktsdk.PokktEvent;
	import com.pokkt.pokktsdk.PokktIntegrationType;
	import com.pokkt.pokktsdk.PokktManager;
	
	import flash.desktop.NativeApplication;
	import flash.events.Event;
	import flash.text.SoftKeyboardType;
	
	import feathers.controls.Check;
	import feathers.controls.TextInput;
	import feathers.controls.text.StageTextTextEditor;
	import feathers.core.ITextEditor;
	
	import starling.display.Button;
	import starling.events.Event;
	import starling.text.TextField;

	public class OfferwallScreen extends BaseScreen
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		[Embed(source="assets/button2.png")]
		public static const BUTTON2:Class;
		
		private var _btnGetOfferwallWithValue:Button;
		private var _btnGetOfferwallWithFixValue:Button;
		private var _btnIncompleteCall:Button;
		
		private var _txtEarnedPoint:TextField;
		private var _inputTxtMaxPoint:TextInput;
		private var _checkBox:Check;
		
		private var _yPadding:int = 15;
		
		private var _callback:Function;
		private var _isActivateCalledAlready:Boolean = false;
		
		private var _pokktConfig:PokktConfig;
		
		public function OfferwallScreen(callback:Function)
		{
			super();
			
			_callback = callback;
			_imgLogo.y = _imgLogo.y/2;
			
			_txtEarnedPoint = GetUIComponent.getTextField("Points earned: 0", 20 * Constants.X_SCALE, false);
			_txtEarnedPoint.x = 10 * Constants.X_SCALE;
			_txtEarnedPoint.y = _imgLogo.y  +_imgLogo.height;
			addChild(_txtEarnedPoint);
			
			_btnGetOfferwallWithValue = GetUIComponent.getButton(BUTTON1, "Get offer wall(Any asset value)", 10);
			_btnGetOfferwallWithValue.y = _txtEarnedPoint.y + _txtEarnedPoint.height + 30 * Constants.Y_SCALE;
			_btnGetOfferwallWithValue.addEventListener(starling.events.Event.TRIGGERED, onGetOfferwallWithValueClick);
			addChild(_btnGetOfferwallWithValue);
			
			_inputTxtMaxPoint = new TextInput();
			_inputTxtMaxPoint.x = 10 * Constants.X_SCALE;
			_inputTxtMaxPoint.y = _btnGetOfferwallWithValue.y + _btnGetOfferwallWithValue.height + _yPadding * Constants.Y_SCALE;
			_inputTxtMaxPoint.restrict = "0-9";
			_inputTxtMaxPoint.textEditorFactory = function ():ITextEditor
			{
				var stte:StageTextTextEditor = new StageTextTextEditor();
				stte.softKeyboardType = SoftKeyboardType.NUMBER;
				return stte;
			};
			_inputTxtMaxPoint.text = "0";
			addChild(_inputTxtMaxPoint);
			
			_btnGetOfferwallWithFixValue = GetUIComponent.getButton(BUTTON2, "Get Offerwall(Fix assets value)", 10);
			_btnGetOfferwallWithFixValue.y = _btnGetOfferwallWithValue.y + (_btnGetOfferwallWithValue.height*2) + _yPadding * Constants.Y_SCALE;
			_btnGetOfferwallWithFixValue.addEventListener(starling.events.Event.TRIGGERED, onGetOfferwallWithFixValueClick);
			addChild(_btnGetOfferwallWithFixValue);
			
			_btnIncompleteCall = GetUIComponent.getButton(BUTTON1, "Incomplete call back", 10);
			_btnIncompleteCall.y = _btnGetOfferwallWithFixValue.y + _btnGetOfferwallWithFixValue.height + _yPadding * Constants.Y_SCALE;
			_btnIncompleteCall.addEventListener(starling.events.Event.TRIGGERED, onIncompleteCallClick);
			addChild(_btnIncompleteCall);
			
			_checkBox = new Check();
			_checkBox.x = 10 * Constants.X_SCALE;
			_checkBox.y = _btnIncompleteCall.y + _btnIncompleteCall.height + _yPadding * Constants.Y_SCALE;
			_checkBox.isSelected = false;
			_checkBox.label = "Close on Success Flag";
			_checkBox.addEventListener(starling.events.Event.CHANGE, toggle_changeHandler);
			addChild(_checkBox);
			
			//
			//Pokkt
			PokktManager.setDebug(true);
			_pokktConfig = new PokktConfig();
			_pokktConfig.securityKey = "iJ02lJss0M";
			_pokktConfig.applicationId = "a2717a45b835b5e9f50284a38d62a74e";
			_pokktConfig.integrationType = PokktIntegrationType.INTEGRATION_TYPE_ALL;
			_pokktConfig.autoCacheVideo = false;
			//PokktManager.startSession(_pokktConfig);
			PokktManager.initPokkt(_pokktConfig);
			
			PokktManager.dispatcher.addEventListener(PokktEvent.COIN_RESPONSE_EVENTS, onCoinResponseSuccess);
			PokktManager.dispatcher.addEventListener(PokktEvent.COIN_RESPONSE_WITH_TRANS_ID_EVENTS, onCoinResponseWithTransID);
			PokktManager.dispatcher.addEventListener(PokktEvent.COIN_RESPONSE_FAILED_EVENTS, onCoinResponseFailed);
			PokktManager.dispatcher.addEventListener(PokktEvent.OFFERWALL_CAMPAIGN_AVAILABLITY_EVENT, onOfferwallAvailability);
			PokktManager.dispatcher.addEventListener(PokktEvent.OFFERWALL_CLOSE_EVENT, onOfferwallClosed);
			
			NativeApplication.nativeApplication.addEventListener(flash.events.Event.ACTIVATE, onActivate, false, 0, true);
			NativeApplication.nativeApplication.addEventListener(flash.events.Event.DEACTIVATE, onDeactivate, false, 0, true);
		}
		
		protected function onOfferwallClosed(event:PokktEvent):void
		{
			trace(event);
		}
		
		protected function onOfferwallAvailability(event:PokktEvent):void
		{
			trace("Offerwall availability: " + event.value);
		}
		
		protected function onDeactivate(event:flash.events.Event):void
		{
			trace("onDeactivate");
			_isActivateCalledAlready = false;
		}
		
		protected function onActivate(event:flash.events.Event):void
		{
			trace("onActivate: " + _isActivateCalledAlready);
			//Checking this condition because onActivate is calling two times sometimes.
			//Don't know the reason. Need to go in deep. Meanwhile keeping condition check here.
			if(!_isActivateCalledAlready)
			{
				PokktManager.getPendingCoins();
			}
			_isActivateCalledAlready = true;
		}
		
		//PokktManager callback function
		protected function onCoinResponseWithTransID(event:PokktEvent):void
		{
			var finalValue:Array = event.value.split(",");
			trace("PokktSDK: onCoinResponseWithTransID: Transaction ID: " + finalValue[0] + " and Earned points: " + finalValue[1]);
		}
		
		private function onCoinResponseSuccess(event:PokktEvent):void
		{
			trace("PokktSDK: onCoinResponseSuccess: " + event.value);
		}
		
		private function onCoinResponseFailed(event:PokktEvent):void
		{
			trace("PokktSDK: onCoinResponseFailed");
		}
		
		//button/toggle click handler
		private function toggle_changeHandler(event:starling.events.Event):void
		{
			trace(_checkBox.isSelected);
			_pokktConfig.closeOnSuccessFlag = _checkBox.isSelected;
		}
		
		protected function onGetOfferwallWithValueClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			_pokktConfig.offerWallAssetValue = "";
			PokktManager.getCoins(_pokktConfig);//pass value if you want to pass like "100"
		}
		
		protected function onGetOfferwallWithFixValueClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			_pokktConfig.offerWallAssetValue = "400";
			PokktManager.getCoins(_pokktConfig);
		}
		
		protected function onIncompleteCallClick(event:starling.events.Event):void
		{
			trace(event.currentTarget);
			PokktManager.getPendingCoins();
		}
		
		override public function dispose():void
		{
			super.dispose();
			PokktManager.dispatcher.removeEventListener(PokktEvent.COIN_RESPONSE_EVENTS, onCoinResponseSuccess);
			PokktManager.dispatcher.removeEventListener(PokktEvent.COIN_RESPONSE_WITH_TRANS_ID_EVENTS, onCoinResponseWithTransID);
			PokktManager.dispatcher.removeEventListener(PokktEvent.COIN_RESPONSE_FAILED_EVENTS, onCoinResponseFailed);
			PokktManager.dispatcher.removeEventListener(PokktEvent.OFFERWALL_CAMPAIGN_AVAILABLITY_EVENT, onOfferwallAvailability);
			PokktManager.dispatcher.removeEventListener(PokktEvent.OFFERWALL_CLOSE_EVENT, onOfferwallClosed);
			NativeApplication.nativeApplication.removeEventListener(flash.events.Event.ACTIVATE, onActivate);
			NativeApplication.nativeApplication.removeEventListener(flash.events.Event.DEACTIVATE, onDeactivate);
		}
	}
}
