package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	
	import starling.display.Button;
	import starling.display.Image;
	import starling.text.TextField;
	import starling.textures.Texture;
	import starling.utils.HAlign;
	
	public class GetUIComponent
	{
		[Embed(source="assets/button1.png")]
		public static const BUTTON1:Class;
		
		public function GetUIComponent()
		{
		}
		
		public static function GetImage(bitmap:Bitmap, x:int, y:int):Image
		{
			var image:Image = Image.fromBitmap(bitmap);
			image.x = x * Constants.X_SCALE;
			image.y = y * Constants.Y_SCALE;
			image.width = image.width / Constants.ContentScaleFactor;
			image.height = image.height / Constants.ContentScaleFactor;
			return image;
		}
		
		public static function getButton(buttonBitmap:Class, text:String, x:int = 0, y:int = 0):Button
		{
			var atlasBitmapData:BitmapData = Bitmap(new buttonBitmap).bitmapData;
			var atlasTexture:Texture = Texture.fromBitmapData(atlasBitmapData, false);

			var button:Button = new Button(atlasTexture, text);
			button.x = x * Constants.X_SCALE;
			button.y = y * Constants.Y_SCALE;
			button.width = atlasTexture.width / Constants.ContentScaleFactor;
			button.height = atlasTexture.height / Constants.ContentScaleFactor;
			button.fontSize = 20 / Constants.ContentScaleFactor;
			return button;
		}
		
		public static function getTextField(text:String, fontSize:int, isBold:Boolean):TextField
		{
			var textField:TextField = new TextField(460 / Constants.ContentScaleFactor, 60 / Constants.ContentScaleFactor, text, "Verdana", fontSize / Constants.ContentScaleFactor, 0, isBold);
			textField.hAlign = HAlign.LEFT;
			//textField.autoSize = TextFieldAutoSize.BOTH_DIRECTIONS;
			return textField;
		}
	}
}